function C = helperCalculateCouplingMatrix(arrayModel, fc, numAnt)
%HELPERCALCULATECOUPLINGMATRIX Helper function for the STBC Transmission
% with Antenna Coupling example. 

% Copyright 2017 The MathWorks, Inc.              

% Calculate impedance matrix
S = sparameters(arrayModel, fc);
Ztx = s2z(squeeze(S.Parameters));

% Enforce symmetry on the impedance matrix
Zu = triu(Ztx);
Zl = Zu.';
Zl([1,4]) = 0;
Ztx = Zl + Zu;

% Form coupling matrix as per Eq. (6) in paper
Zload = Ztx(1,1)';
Zlm = Zload .* eye(prod(numAnt));
C = (Zload + Ztx(1,1)) .* inv((Ztx + Zlm));

% [EOF]